' Automatische Antwort zurcksenden
' Andreas Heim <software@heimweb.de>
' http://www.heimweb.de                                   
' Verschiedenste Arten von From bzw. Reply-To werden abgefangen
'                                    
Const ForReading = 1, ForWriting = 2, ForAppending = 8

TempFileConst="_tmp.msg"            'Zwischendatei
MessageFile="Message.TXT"           'Antwort-Mail
MailInFolder="..\Mails\pgp"         'Verzeichnis mit zu verarbeitenden Mails
MailOutFolder="..\Mails\Mail.Out\"
MailZielFolder="..\Mails\admin\"    'Hier kommen die verarbeiteten Mails hin (wenn gewnscht) 
MessageExtention=".msg"

Set fso          = CreateObject( "Scripting.FileSystemObject" )
Set InOrdner       = fso.GetFolder(MailInFolder)
Set Quelldateien = InOrdner.Files

FileNr=0

For Each f1 in Quelldateien                             ' Alle Dateien in diesem Ordner verarbeiten
   If InStr(1,f1.name,MessageExtention,1) then            ' jedoch nur *.msg Files bearbeiten
      FileNr = FileNr +1
   
      TempFile = CStr(FileNr) & TempFileConst              ' TempFilname zusammenbauen
      ' Files ffnen
      Set QuellDatei    = fso.OpenTextFile(f1.path,ForReading)      
      TextName=""
      TextAdresse=""
      Do While Quelldatei.AtEndOfStream <> True            ' Quelldatei verarbeiten 
         TextPuffer=QuellDatei.ReadLine
         If ( (InStr(1,TextPuffer,"Reply-To:",1)=1) ) then
            TextName    = FromName(TextPuffer)
            TextAdresse = FromAdresse(TextPuffer)
            Exit Do                                        ' Reply-To hat hhere Prio als From -> aufhren
         ElseIf ( (InStr(1,TextPuffer,"From:",1)=1) ) then
            TextName    = FromName(TextPuffer)
            TextAdresse = FromAdresse(TextPuffer)                                                       
         ElseIf ( (InStr(1,TextPuffer,"",1)=0) )then
            Exit Do                                        ' bei Leerzeile ist Header zu Ende -> aufhren
         End If
      Loop  

' Hier wird geprft ob From oder Reply-To berhaupt gefunden wurden.
' ansonsten ist TextAdresse leer -> es kommt im Hamster zu einem Fehler
' SendMail failed: RCPT TO:   -> 501 RCPT TO must have an address operand
' SendMail aborted: No valid recipients!
' Hamster versucht zu antworten......
      if TextAdresse > "" then     
       
         ' neue Anschriftsadresse ermitteln      
         ToName      = STo(TextName,TextAdresse)
         ToAdresse   = XTo(TextAdresse)
      
         ' "neue" Mail schreiben  
         Set ZielDatei     = fso.OpenTextFile( TempFile, ForWriting, True) 
         Set MessageDatei  = fso.OpenTextFile(MessageFile,ForReading) 
         Do While MessageDatei.AtEndOfStream <> True
            TextPuffer=MessageDatei.ReadLine
            If ( (InStr(1,TextPuffer,"!RCPT TO:",1)=1) ) then
               ZielDatei.WriteLine(ToAdresse)
            ElseIf ( (InStr(1,TextPuffer,"To:",1)=1) ) then
               ZielDatei.WriteLine(ToName)
            else
               ZielDatei.WriteLine(TextPuffer)
            End If
         Loop
         MessageDatei.Close
         ZielDatei.Close
         fso.CopyFile    TempFile,MailOutFolder         ' neue Mail in Out
         fso.DeleteFile  TempFile,true                  ' Temp File lschen
      end if
      ' hier knnte evtl (else) noch eine Himweisnachricht zum Admin
      
      QuellDatei.Close
                           
      fso.CopyFile    f1.path,MailZielFolder         ' Original zum admin (kann entfallen)
      fso.DeleteFile  f1.path,true                   ' Original lschen
   End If
Next

WScript.Quit
'###################### ENDE #####################                                                                                      
                                                                                      
' Aus From: oder Reply-To: den (Real)Namen ausschneiden          
function FromName(Text)
SuchZeichenA = Chr(40)
SuchZeichenE = Chr(41) 
Dim Name 
Name = ""

   Begin =InStr(1,Text,Chr(34),1)              'erstes Hochkomma " suchen
   Ende  =InStr(Begin+1,Text,Chr(34),1)        'zweites Hochkomma " suchen 
                     
   if Begin = 0 or Ende = 0   then             ' nichts gefunden Klammern suchen  
      Begin =InStr(1,Text,SuchZeichenA,1)      'Klammern ()
      Ende  =InStr(1,Text,SuchzeichenE,1)
   end if      
   
   if Begin = 0 or Ende = 0   then               
     Name = ""                                 ' nicht's gefunden
   else	
     Name = Mid(Text, Begin, Ende-Begin+1)     'rausschneiden
   end if
   FromName = Name   
end function

' Aus From: oder Reply-To: den (Real)Namen ausschneiden          
function FromAdresse(Text)    
Dim Name 
Name = ""
SuchZeichenA = "<"
SuchZeichenE = ">"
SuchZeichenD = ":"
   Begin =InStr(1,Text,SuchZeichenA,1) 
   Ende  =InStr(1,Text,SuchZeichenE,1)       
   if Begin = 0 or Ende = 0   then               
      Begin =InStr(1,Text,SuchZeichenD,1) 
      Name = "<"+Mid(Text, Begin+2)+">"                  ' es gibt keine <> Klammern -> alles nehmen ab : +1
   else	
      Name = Mid(Text, Begin, Ende-Begin+1)
   end if
   FromAdresse = Name   
end function


function XTo(Name)
   Dim Datenfeld(2)
   Datenfeld(0) = "!RCPT TO:"
   Datenfeld(1) = Name
   XTo = Join(Datenfeld)           ' Empfnger zusammenbauen
                   
end function

function STo(Name,Adresse)
   Dim Datenfeld(2)
   Datenfeld(0) = "To:"
   if  Name <> ""   then
   Datenfeld(1) = Name
   else 
   Datenfeld(1) = ""
   end if 
   Datenfeld(2) = Adresse
   STo = Join(Datenfeld)           ' Empfnger+ Name zusammenbauen
                   
end function

         