#!hs2
#########################################################################
# Script     : AutoBot.hsc
# Description: Bot which can start instantly scripts or other programs
#              for revising in- and outgoing postings
# Maintainer : Wolfgang Jth <wjaeth@bigfoot.de>
# Version    : 1.0.1
# Date       : 05.12.2000
#########################################################################
# Remark: This script is pre-configured for starting 'MailMan.hsc'
# Preferences:
#    hamster.ini  [Actions]
#                 mail.out.exec=Hamster.exe
#                 mail.out.pars=AutoBot.hsc MailOut "%1"
#                 (entries for mail.in, news.out etc. would be adequate)
# ATTENTION:
#    'mail.internal' in hamsater.ini does mean emails generated by
#    hamster itself (like the daily statistics). It's parameter for
#    this script is 'hamsterorigin'. Emails from one internal user to
#    another internal one take their way over 'mail.out'!
#########################################################################

#!trace 0
#!debug 0

#!load hamster.hsm        { HamRequireVersion }

debug ( 200 , "<<< script 'AutoBot.hsc' >>>" )

varset ( $hamRequired    , "1.3.22.00")



#########################################################################
# Main procedure : Distributes each posting to the corresponding
#                  subroutine
#########################################################################
#Parameters: none

Label (Main)
#============
   var( $i1 )
   HamRequireVersion ( $hamRequired, True )
   icase ( lowercase ( ParamStr(1) ), _
      "mailout",       MailOut ( ParamStr(2) ), _
      "mailin",        MailIn  ( ParamStr(2) ), _
      "newsout",       NewsOut ( ParamStr(2) ), _
      "newsin",        NewsIn  ( ParamStr(2) ), _
      "hamsterorigin", Hamster ( ParamStr(2) ), _
      "",    false, {if there's no parameter, just ignore the call} _
      else,  QuitScript ( "Unknown first parameter:  ' " + ParamStr(1) + " '" ) )
Quit ( 0 )



#########################################################################
# MailOut : Handles all mails sent by some client (further dispatched
#           by destination)
#########################################################################
#Parameters: name of file
#Return value: none

Sub MailOut ($FileName)
#=======================
   # initaite specific accounts/directories (depends on what you want to do):
   varset ( $MailOut, lowercase ( HamMailsOutPath ) )
   varset ( $MailMan, lowercase ( IniRead ( "MailMan.ini", "MailMan", "Account", "MailMan" ) ) )

   icase ( AccountOf ( $FileName ),  _
      $MailOut, OutMail2External ( $FileName ),  _
      $MailMan, RunScript ( "MailMan.hsc", $FileName, false ), _
      { Do you have other speccial accounts? } _
      else,     OutMail2Internal ( $FileName ) )
EndSub



# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# OutMail2External : Handles all mails sent by some client to any
#                    external server
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#Parameters: name of file
#Return value: none

Sub OutMail2External ($FileName)
#================================
# Maybe you wanna do something with common outgoing mail?
# Example (myabe you must correct the path to KorrNews):
#   Execute ( "KorrNews.exe Type:mail Filename:""" +  $FileName + """" )
   warning ( "At the moment, nothing is defined for outgoing mails like '" + $FileName + "'" )
EndSub



# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# OutMail2Internal : Handles all mails sent by some client to any
#                    other internal client
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#Parameters: name of file
#Return value: none

Sub OutMail2Internal ($FileName)
#================================
# Maybe you wanna do something with internaly delivered mail?
   warning ( "At the moment, nothing is defined for internaly delivered mails like '" + $FileName + "'" )
EndSub



#########################################################################
# MailIn : Handles all mails received from some external server
#          (further dispatched by destination)
#########################################################################
#Parameters: name of file containing the mail
#Return value: none

Sub MailIn ($FileName)
#======================
# Maybe you need to initiate specific accounts/directories (depends
# on what you want to do)
   icase ( AccountOf ( $FileName ),  _
      "admin", InMail2Internal ( $FileName ), { just as example } _
      { but maybe you have speccial accounts like an auto reply? } _
      else, InMail2Internal ( $FileName ) )
EndSub



# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# InMail2Internal : Handles all mails received from some external
#                   server to any not-special account
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#Parameters: name of file
#Return value: none

Sub InMail2Internal ($FileName)
#===============================
# Maybe you wanna do something with incomming mail? Maybe KorrNews, too?
   warning ( "At the moment, nothing is defined for incoming mails like '" + $FileName + "'" )
EndSub



#########################################################################
# Hamster : Handles all mails generated by hamster itself
#########################################################################
#Parameters: name of file containing the mail
#Return value: none

Sub Hamster ($FileName)
#=======================
# Maybe you wanna do something with hamster-generated postings?
   warning ( "At the moment, nothing is defined for hamster generated mails like '" + $FileName + "'" )
EndSub



#########################################################################
# NewsOut : Handles all news articles sent by some client to any
#           external server
#########################################################################
#Parameters: name of file containing the article
#Return value: none

Sub NewsOut ($FileName)
#=======================
# Maybe you wanna do something with outgoing news?
# Example (myabe you must correct the path to KorrNews):
#   Execute ( "KorrNews.exe Type:news Filename:""" +  $FileName + """" )
   warning ( "At the moment, nothing is defined for outgoing news articles like '" + $FileName + "'" )
EndSub



#########################################################################
# NewsIn : Handles all news articles received from any external server
# ATTENTION: This feature is not availeable at time
#########################################################################
#Parameters: name of file containing the article
#Return value: none

Sub NewsIn ($FileName)
#======================
# If this feature would ever be available, you might do waht you want
# with incomming news.
   warning ( "At the moment, nothing is defined for incomming news articles like '" + $FileName + "'" )
EndSub



# - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - #
# QuitScript : Quits script with specified error message
# - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - #
#Parameters: error message
#Return value: none

Sub QuitScript ($ErrMsg)
#========================
   error ( $ErrMsg )
EndSub



# - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - #
# AccountOf : Extracts the corresponding account from the file path
# - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - # - #
#Parameters: name of file containing the article
#Return value: account (subdirectory) name

Sub AccountOf ($FullFileName)
#=============================
   var ( $Path, $Account, $File )

   RE_Parse( $FullFileName, "^(.*)\\([^\\]*)\\([^\\]*)$", $Path, $Account, $File )
   if ( $Account == "" )
      error ( "Invalid filename (must be with full path). Parameter:  ' " + $Path + " '" )
   endif
   $Path = lowercase ( $Path + "\" + $Account + "\" )
   if ( $Path == lowercase ( HamMailsOutPath ) )
      $Account = $Path
   endif
   return ( lowercase ( $Account ) )
EndSub



#----------   End of File   ----------