#!hs2
########################################################################
# Script     : MailMan.hsc
# Description: handling of filtered mails (details see MailMan.txt)
# Maintainer : Wolfgang Jth <wjaeth@bigfoot.de>
# Version    : 2.0.0
# Date       : 25.11.2000
########################################################################

#!trace 0
#!debug 0

#!load hamster.hsm        { HamRequireVersion }
#!load hmessage.hsm       { MsgIndexOfHeader }
#!load htime.hsm          { FormatDateTime }
#!load hwindows.hsm       { $MB_xxx constants }

debug ( 200 , "<<< script 'mailman.hsc' >>>" )

varset ( $hamRequired    , "1.3.22.0")
varset ( $thisScript     , "MailMan")
varset ( $thisVersion    , "2.0.1")
varset ( $ScriptVersion  , $thisScript + " " + $thisVersion )

varset ( $MailMan        , "MailMan" )      # option(s) configurable by ini file

varset ( $tagPrefix      , "<Prefix>" )     # Tags for splitting subject line
varset ( $tagAction      , "<Action>" )
varset ( $tagMatch       , "<Match>" )
varset ( $tagContent     , "<Content>" )
varset ( $tagSection     , "<Section>" )
varset ( $tagBody        , "<Body>" )
varset ( $tagSubject     , "Subject:" )
varset ( $tagFrom        , "From:" )
varset ( $tagDate        , "Date:" )
varset ( $tagMID         , "Message-ID:" )

varset ( $fileMailFilt   , "MailFilt.hst")  # misceancelous constants

varset ( $Idx            , 1 )

Label (Main)
#============
   var ( $MailAccount, $ArticleList, $ExistingMail, $i1 )
   Init
   $MailAccount = HamMailPath + $MailMan + "\"
   if ( ! DirExists ( $MailAccount ) )
      varset ( $errDirExist,  "Unable to locate this directory " + _
                                        "(please check the configuration):" )
      MsgBox ( $errDirExist + $CRLF + $MailAccount, $ScriptVersion, _
                                                            $MB_ICONWARNING )
      Error ( $ScriptVersion + ": " + $errDirExist + " '" + _
                                                         $MailAccount + "'" )
   else
      $ArticleList = ListAlloc
      if ( ParamCount > 0 )
         ListAdd ( $ArticleList, ParamStr($Idx) )
      else
         ListFiles ( $ArticleList, $MailAccount + "*.msg", true )
      endif
      for ( $i1, 0, ListCount ( $ArticleList ) - 1 )
         $ExistingMail = ListGet ( $ArticleList, $i1 )
         if ( ParseMail ( $ExistingMail ) == True )
            FileDelete ( $ExistingMail )
         else
            FileRename ( $ExistingMail, $ExistingMail + ".err" )
         endif
      endfor
      ListFree ( $ArticleList )
   endif
#   Done
Quit ( 0 )



Sub Init
#========
   varset ( $iniHamster, "Hamster.ini" )
   varset ( $iniMailMan, "MailMan.ini" )
   varset ( $iniSection, "MailMan" )
   HamRequireVersion ( $hamRequired, True )
   if ( ParamStr(1) = "mail.local" )
      $Idx =  2    
   endif
  $MailMan = IniRead ( $iniMailMan, $iniSection, "Account", $MailMan )
EndSub



Sub ParseMail ($sExistingMail)
#==============================
   var ( $Headers, $newFilter, $isOK )

   print ( "Parsing " + $sExistingMail )
   $Headers = ListLoadHeaders ( $sExistingMail )

   $isOK = ( len ( ListGetKey ( $Headers, $tagAction ) ) > 0 ) && _
           ( len ( ListGetKey ( $Headers, $tagMatch  ) ) > 0 )
   if ( $isOK )
      $newFilter = ListSetFilter ( $Headers )
      ListSetKey ( $Headers, $tagBody, ListGetText( $newFilter ) )
#      SendAck ( $Headers ) # this feature is still under construction
      ListFree ( $newFilter )
   else
      warning ( $ScriptVersion + ": Could not execute order in " + _
                                                             $sExistingMail )
      warning ( $ScriptVersion + ": " + $tagFrom + " " + _
                                          ListGetKey ( $Headers, $tagFrom ) )
      warning ( $ScriptVersion + ": " + $tagDate + " " + _
                                          ListGetKey ( $Headers, $tagDate ) )
      warning ( $ScriptVersion + ": " + $tagSubject + " " + _
                                       ListGetKey ( $Headers, $tagSubject ) )
      debug ( 50, $ScriptVersion +": " + $tagPrefix + " = '" + _
                                  ListGetKey ( $Headers, $tagPrefix ) + "'" )
      debug ( 50, $ScriptVersion +": " + $tagAction + " = '" + _
                                  ListGetKey ( $Headers, $tagAction ) + "'" )
      debug ( 50, $ScriptVersion +": " + $tagMatch + " = '" + _
                                   ListGetKey ( $Headers, $tagMatch ) + "'" )
      debug ( 50, $ScriptVersion +": " + $tagContent + " = '" + _
                                 ListGetKey ( $Headers, $tagContent ) + "'" )
#      SendErr ( $Headers ) # this feature is still under construction
   endif

   ListFree ( $Headers )
   return ( $isOK )
EndSub



Sub ListLoadHeaders ($sExistingMail)
#====================================
   var ( $Article, $Headers, $HeaderTag, $HeaderContent, $i1, $i2 )

   $Headers = ListAlloc
   $Article = ListAlloc
   If ( ListLoad ( $Article, $sExistingMail ) != 0 )
      warning ( $ScriptVersion + ":  Error on opening file " + $sExistingMail )
   else
      AddHeader ( $Article, $Headers, $tagDate )
      AddHeader ( $Article, $Headers, $tagFrom )
      AddHeader ( $Article, $Headers, $tagSubject )
      AddHeader ( $Article, $Headers, $tagMID )
   endif
   ListFree ( $Article )

   SplitSubject ( $Headers, ListGetKey ( $Headers, $tagSubject ) )

   return ( $Headers )
EndSub



Sub AddHeader ($lArticle, $lHeaders, $sHeader)
#==============================================
   var ( $HeaderTag, $HeaderContent, $Index )

   $Index = MsgIndexOfHeader ( $lArticle, $sHeader )
   if ( $Index < 0 )
      ListAdd ( $lHeaders, $HeaderTag + "=" )
   else
      RE_Parse ( ListGet ( $lArticle, $Index ), "(\S+:)\s+(.*)", _
                                                 $HeaderTag, $HeaderContent )
      ListAdd ( $lHeaders, $HeaderTag + "=" + $HeaderContent )
   endif
EndSub



Sub SplitSubject (*$lHeaders, $sSubject)
#========================================
   var ( $Section, $Prefix, $Action, $Match, $Content, $QuotMark, $i1, $i2 )

                # identify any section (if given): '[<section>]<content>'
   RE_Parse ( $sSubject, "\[([^\]]+)\]\s*(.+)$", $Section, $Content )
   if ( len ( $Section ) > 0)
      $sSubject = $Content
   else
      $Section = "*"
   endif
                # split subject header (i.e. 'load Subject: FAQ')
   RE_Parse ( $sSubject, "(\S+)\s+(\S+)\s+(.+)$", $Action, $Match, $Content )

                # '=' bevore 'load' or 'kill'?
   if ( copy ( $Action, 1, 1 ) == "=" )
      $Prefix = "="
      $Action = delete ( $Action, 1, 1 )
   else
      $Prefix = ""
   endif

                # any quotation mark set?
   $QuotMark = ""
   $i1 = copy ( $Content, 1, 1 )
   if ( ($i1 == "'") || ($i1 == """") )
      $i2 = copy ( $Content, len ( $Content ), 1 )
      if ( $i1 == $i2 )
         $QuotMark = $i1
      endif
   endif
   if ( $QuotMark == "" )        # no (so let's set some)
      $Content = """" + $Content + """"
   else
      if ( $QuotMark == "'" )    # yes, single ones
         $Content = copy ( $Content, 2, len($Content)-2 )
      endif
   endif

   if ( RE_Match ( $Action, "(kill|load)" ) )        # |show|store ?
      ListSetKey ( $lHeaders, $TagAction,  $Action )
      ListSetKey ( $lHeaders, $tagPrefix,  $Prefix )
      ListSetKey ( $lHeaders, $tagMatch,   $Match )
      ListSetKey ( $lHeaders, $tagContent, $Content )
      ListSetKey ( $lHeaders, $tagSection, $Section )
   endif
EndSub



Sub ListSetFilter ($lHeaders)
#=============================
   var ( $oldFilter, $newLine )

   $oldFilter = ListAlloc
                # ignore any error (especially if file not found)
   ListLoad ( $oldFilter, HamPath + $fileMailFilt )

                # make a break
#   ListAdd ( $oldFilter, "")
                # first (comment) line
#   ListAdd ( $oldFilter, chr(0x09) + "# " + $thisScript + ", " + _
#                             FormatDateTime ( time, "dd.mm.yyyy hh:nn:ss" ) )
                # second (comment) line
   $newLine = "# " + $tagFrom + " " + ListGetKey ( $lHeaders, $tagFrom ) + _
                  " / " + $tagDate + " " + ListGetKey ( $lHeaders, $tagDate )
                # section line
   ListAdd ( $oldFilter, "[" + ListGetKey ( $lHeaders, $tagSection ) + _
                                                 "]" + chr(0x09) + $newLine )
                # filter line
   $newLine = ListGetKey ( $lHeaders, $tagPrefix ) + ListGetKey ( _
                    $lHeaders, $tagAction ) + " " + ListGetKey ( $lHeaders, _
                    $tagMatch ) + " " + ListGetKey ( $lHeaders, $tagContent )
   ListAdd ( $oldFilter, $newLine )
   print ( "[" + $fileMailFilt + "] " + $newLine )

   ListSave ( $oldFilter, HamPath + $fileMailFilt )
   return ( $oldFilter )
EndSub



#----------   End of File   ----------
